from selenium.webdriver.support.wait import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC

from pages.base_page import BasePage

class PopupsPage(BasePage):
    PAGE_URL = "https://practice-automation.com/popups/"

    ALERT_BUTTON = ("id", "alert")
    CONFIRM_BUTTON = ("id", "confirm")
    PROMPT_BUTTON = ("id", "prompt")
    CONFIRM_RESULT = ("id", "confirmResult")
    PROMPT_RESULT = ("id", "promptResult")
    TOOLTIP_ELEMENT = ("class name", "tooltip_1")
    TOOLTIP_TEXT = ("class name", "tooltip_text")

    """
    Alert Popup
    """
    def click_alert_button(self):
        self.find_and_click(self.ALERT_BUTTON)

    def get_alert_text(self):
        WebDriverWait(self.driver, 2).until(EC.alert_is_present())
        alert = self.driver.switch_to.alert
        text = alert.text
        alert.accept()
        return text

    """
    Confirm Popup
    """
    def click_confirm_button(self):
        self.find_and_click(self.CONFIRM_BUTTON)

    def handle_confirm_alert(self, accept=True):
        WebDriverWait(self.driver, 2).until(EC.alert_is_present())
        alert = self.driver.switch_to.alert
        if accept:
            alert.accept()
        else:
            alert.dismiss()

    def get_confirm_result(self):
        return self.driver.find_element(*self.CONFIRM_RESULT).text

    """
    Prompt Popup
    """
    def click_prompt_button(self):
        self.find_and_click(self.PROMPT_BUTTON)

    def handle_prompt_alert(self, text=None):
        WebDriverWait(self.driver, 2).until(EC.alert_is_present())
        alert = self.driver.switch_to.alert
        if text:
            alert.send_keys(text)
        alert.accept()

    def get_prompt_result(self):
        return self.driver.find_element(*self.PROMPT_RESULT).text

    """
    Tooltip
    """
    def click_tooltip(self):
        self.find_and_click(self.TOOLTIP_ELEMENT)

    def is_tooltip_visible(self):
        tooltip_text = self.driver.find_element(*self.TOOLTIP_TEXT)
        return "show" in tooltip_text.get_attribute("class") and tooltip_text.is_displayed()

    def get_tooltip_text(self):
        return self.driver.find_element(*self.TOOLTIP_TEXT).text

    def wait_for_tooltip_visible(self):
        WebDriverWait(self.driver, 2).until(
            EC.visibility_of_element_located(self.TOOLTIP_TEXT)
        )

    def wait_for_tooltip_hidden(self):
        WebDriverWait(self.driver, 2).until(
            EC.invisibility_of_element_located(self.TOOLTIP_TEXT)
        )